/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.util;

import com.tiviacz.pizzacraft.blockentity.PizzaBagBlockEntity;
import com.tiviacz.pizzacraft.container.PizzaBagMenu;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class Utils {
    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static ItemStackHandler createHandlerFromStack(ItemStack stack, int size) {
        ItemStackHandler handler = new ItemStackHandler(size);
        if (stack.m_41783_() != null) {
            handler.deserializeNBT(stack.m_41783_().m_128469_("Inventory"));
        }
        return handler;
    }

    public static void spawnItemStackInWorld(Level level, BlockPos pos, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        itemEntity.m_32060_();
        level.m_7967_((Entity)itemEntity);
    }

    public static int calculatePlayersUsing(Level level, PizzaBagBlockEntity tile, int p_213976_2_, int p_213976_3_, int p_213976_4_) {
        int i = 0;
        for (Player player : level.m_45976_(Player.class, new AABB((double)((float)p_213976_2_ - 5.0f), (double)((float)p_213976_3_ - 5.0f), (double)((float)p_213976_4_ - 5.0f), (double)((float)(p_213976_2_ + 1) + 5.0f), (double)((float)(p_213976_3_ + 1) + 5.0f), (double)((float)(p_213976_4_ + 1) + 5.0f)))) {
            if (!(player.f_36096_ instanceof PizzaBagMenu)) continue;
            ++i;
        }
        return i;
    }

    public static boolean checkCount(ItemStack stack1, ItemStack stack2, int count) {
        return stack1.m_41613_() + stack2.m_41613_() <= count;
    }

    public static boolean checkItemStacks(ItemStack stack1, ItemStack stack2) {
        return !stack1.m_41619_() && stack1.m_41720_() == stack2.m_41720_();
    }

    public static boolean checkItemStacksAndCount(ItemStack stack1, ItemStack stack2, int count) {
        return Utils.checkItemStacks(stack1, stack2) && Utils.checkCount(stack1, stack2, count);
    }

    public static int getProperSlotForInsert(ItemStack stack, IItemHandlerModifiable inv) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!inv.getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return 0;
    }

    public static int getProperSlotForExtract(IItemHandlerModifiable inv) {
        for (int i = inv.getSlots() - 1; i > 0; --i) {
            if (inv.getStackInSlot(i).m_41619_()) continue;
            return i;
        }
        return 0;
    }
}

